/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.entity;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.client.AllBogeyStyleRenders;
import com.zurrtum.create.client.content.contraptions.render.ClientContraption;
import com.zurrtum.create.client.content.contraptions.render.OrientedContraptionEntityRenderer;
import com.zurrtum.create.client.content.trains.bogey.BogeyBlockEntityRenderer;
import com.zurrtum.create.client.content.trains.entity.CarriageClientContraption;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.CarriageBogey;
import com.zurrtum.create.content.trains.entity.CarriageContraption;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4604;
import net.minecraft.class_5617;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class CarriageContraptionEntityRenderer
extends OrientedContraptionEntityRenderer<CarriageContraptionEntity, CarriageContraptionState> {
    public CarriageContraptionEntityRenderer(class_5617.class_5618 context) {
        super(context);
    }

    @Override
    public CarriageContraptionState createRenderState() {
        return new CarriageContraptionState();
    }

    @Override
    public boolean shouldRender(CarriageContraptionEntity entity, class_4604 clippingHelper, double cameraX, double cameraY, double cameraZ) {
        Carriage carriage = entity.getCarriage();
        if (carriage != null) {
            for (CarriageBogey bogey : carriage.bogeys) {
                if (bogey == null) continue;
                bogey.couplingAnchors.replace(v -> null);
            }
        }
        if (!entity.validForRender || entity.firstPositionUpdate) {
            return false;
        }
        return super.shouldRender(entity, clippingHelper, cameraX, cameraY, cameraZ);
    }

    @Override
    public void extractRenderState(CarriageContraptionEntity entity, CarriageContraptionState state, float tickProgress) {
        class_2338 bogeyPos;
        super.extractRenderState(entity, state, tickProgress);
        Carriage carriage = entity.getCarriage();
        if (carriage == null) {
            return;
        }
        class_1937 level = entity.method_73183();
        Couple<CarriageBogey> bogeys = carriage.bogeys;
        CarriageBogey first = (CarriageBogey)bogeys.getFirst();
        CarriageBogey second = (CarriageBogey)bogeys.getSecond();
        class_243 position = entity.method_30950(tickProgress);
        float viewYRot = entity.method_5705(tickProgress);
        float viewXRot = entity.method_5695(tickProgress);
        int bogeySpacing = carriage.bogeySpacing;
        float firstYaw = first.yaw.getValue(tickProgress);
        float firstPitch = first.pitch.getValue(tickProgress);
        float secondYaw = 0.0f;
        float secondPitch = 0.0f;
        first.updateCouplingAnchor(position, viewXRot, viewYRot, bogeySpacing, firstYaw, firstPitch, true);
        if (second == null) {
            first.updateCouplingAnchor(position, viewXRot, viewYRot, bogeySpacing, firstYaw, firstPitch, false);
        } else {
            secondYaw = second.yaw.getValue(tickProgress);
            secondPitch = second.pitch.getValue(tickProgress);
            second.updateCouplingAnchor(position, viewXRot, viewYRot, bogeySpacing, secondYaw, secondPitch, false);
        }
        if (VisualizationManager.supportsVisualization((class_1936)level)) {
            return;
        }
        int cameraLight = -1;
        if (!state.contraption.isHiddenInPortal(class_2338.field_10980)) {
            class_243 pos = first.getAnchorPosition();
            int light = pos != null ? CarriageContraptionEntityRenderer.getBogeyLightCoords(level, pos) : (cameraLight = CarriageContraptionEntityRenderer.getBogeyLightCoords(level, entity.method_31166(tickProgress)));
            state.firstBogey = CarriageBogeyRenderState.create(first, viewXRot, viewYRot, bogeySpacing, firstYaw, firstPitch, light, tickProgress);
        }
        if (second != null && !state.contraption.isHiddenInPortal(bogeyPos = class_2338.field_10980.method_10079(entity.getInitialOrientation().method_10160(), bogeySpacing))) {
            class_243 pos = second.getAnchorPosition();
            int light = pos != null ? CarriageContraptionEntityRenderer.getBogeyLightCoords(level, pos) : (cameraLight == -1 ? CarriageContraptionEntityRenderer.getBogeyLightCoords(level, entity.method_31166(tickProgress)) : cameraLight);
            state.secondBogey = CarriageBogeyRenderState.create(second, viewXRot, viewYRot, bogeySpacing, secondYaw, secondPitch, light, tickProgress);
        }
    }

    @Override
    protected ClientContraption createClientContraption(Contraption contraption) {
        return new CarriageClientContraption((CarriageContraption)contraption);
    }

    @Override
    public void submit(CarriageContraptionState state, class_4587 ms, class_11659 queue, class_12075 cameraRenderState) {
        super.submit(state, ms, queue, cameraRenderState);
        if (state.firstBogey != null) {
            state.firstBogey.render(ms, queue);
        }
        if (state.secondBogey != null) {
            state.secondBogey.render(ms, queue);
        }
    }

    public static void translateBogey(class_4587 ms, CarriageBogey bogey, int bogeySpacing, float viewYRot, float viewXRot, float yaw, float pitch) {
        boolean selfUpsideDown = bogey.isUpsideDown();
        boolean leadingUpsideDown = bogey.carriage.leadingBogey().isUpsideDown();
        ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of(ms).rotateYDegrees(viewYRot + 90.0f)).rotateXDegrees(-viewXRot)).rotateYDegrees(180.0f)).translate(0.0f, 0.0f, bogey.isLeading ? 0.0f : (float)(-bogeySpacing)).rotateYDegrees(-180.0f)).rotateXDegrees(viewXRot)).rotateYDegrees(-viewYRot - 90.0f)).rotateYDegrees(yaw)).rotateXDegrees(pitch)).translate(0.0f, 0.5f, 0.0f).rotateZDegrees(selfUpsideDown ? 180.0f : 0.0f)).translateY(selfUpsideDown != leadingUpsideDown ? 2.0f : 0.0f);
    }

    public static int getBogeyLightCoords(class_1937 world, class_243 pos) {
        class_2338 lightPos = class_2338.method_49638((class_2374)pos);
        return class_765.method_23687((int)world.method_8314(class_1944.field_9282, lightPos), (int)world.method_8314(class_1944.field_9284, lightPos));
    }

    @Environment(value=EnvType.CLIENT)
    public static class CarriageContraptionState
    extends OrientedContraptionEntityRenderer.OrientedContraptionState {
        public CarriageBogeyRenderState firstBogey;
        public CarriageBogeyRenderState secondBogey;
    }

    @Environment(value=EnvType.CLIENT)
    public static class CarriageBogeyRenderState {
        public BogeyBlockEntityRenderer.BogeyRenderState data;
        public float viewYRot;
        public float viewXRot;
        public float yRot;
        public int offsetZ;
        public float yaw;
        public float pitch;
        public float zRot;
        public int offsetY;

        public void render(class_4587 matrices, class_11659 queue) {
            matrices.method_22903();
            if (this.offsetZ != 0) {
                matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation(this.viewYRot));
                matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(-this.viewXRot));
                matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation(this.yRot));
                matrices.method_46416(0.0f, 0.0f, (float)this.offsetZ);
                matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation(-this.yRot));
                matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(this.viewXRot));
                matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation(-this.viewYRot));
            }
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation(this.yaw));
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(this.pitch));
            matrices.method_46416(0.0f, 0.5f, 0.0f);
            if (this.zRot != 0.0f) {
                matrices.method_22907((Quaternionfc)class_7833.field_40718.rotation(this.zRot));
            }
            matrices.method_46416(0.0f, (float)this.offsetY, 0.0f);
            this.data.render(matrices, queue);
            matrices.method_22909();
        }

        @Nullable
        public static CarriageBogeyRenderState create(CarriageBogey bogey, float viewXRot, float viewYRot, int bogeySpacing, float yaw, float pitch, int light, float tickProgress) {
            boolean leadingUpsideDown;
            float wheelAngle = bogey.wheelAngle.getValue(tickProgress);
            BogeyBlockEntityRenderer.BogeyRenderState data = AllBogeyStyleRenders.getRenderData(bogey.getStyle(), bogey.getSize(), tickProgress, light, wheelAngle, bogey.bogeyData, true);
            if (data == null) {
                return null;
            }
            CarriageBogeyRenderState state = new CarriageBogeyRenderState();
            state.data = data;
            if (!bogey.isLeading) {
                state.viewYRot = (float)Math.PI / 180 * (viewYRot + 90.0f);
                state.viewXRot = (float)Math.PI / 180 * viewXRot;
                state.yRot = (float)Math.PI;
                state.offsetZ = -bogeySpacing;
            }
            state.yaw = (float)Math.PI / 180 * yaw;
            state.pitch = (float)Math.PI / 180 * pitch;
            boolean selfUpsideDown = bogey.isUpsideDown();
            if (selfUpsideDown) {
                state.zRot = (float)Math.PI;
            }
            if (selfUpsideDown != (leadingUpsideDown = bogey.carriage.leadingBogey().isUpsideDown())) {
                state.offsetY = 2;
            }
            return state;
        }
    }
}

